<?php 
session_start();
error_reporting(0);
include('includes/config.php');

if (isset($_POST['submit'])) {
    $fullname = $_POST['fullname'];
    $fathername = $_POST['fathername'];
    $mobile = $_POST['mobileno'];
    $email = $_POST['emailid'];
    $age = $_POST['age'];
    $gender = $_POST['gender'];
    $bloodgroup = $_POST['bloodgroup'];
    $last_donate = $_POST['last_donate'];
    $district = $_POST['district'];
    $thana = $_POST['thana'];
    $union = $_POST['union'];
    $village = $_POST['village'];
    $status = 1;
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    // File upload handling
    $profilePhoto = $_FILES['profile_photo'];
    $targetDir = "uploads/profile_photos/";
    $fileName = time() . "_" . basename($profilePhoto['name']);
    $targetFilePath = $targetDir . $fileName;
    $fileType = strtolower(pathinfo($targetFilePath, PATHINFO_EXTENSION));

    $allowedTypes = ['jpg', 'jpeg', 'png'];
    if (in_array($fileType, $allowedTypes)) {
        if (move_uploaded_file($profilePhoto['tmp_name'], $targetFilePath)) {
            // Check if email exists
            $ret = "SELECT EmailId FROM tblblooddonars WHERE EmailId=:email";
            $query = $dbh->prepare($ret);
            $query->bindParam(':email', $email, PDO::PARAM_STR);
            $query->execute();

            if ($query->rowCount() == 0) {
                $sql = "INSERT INTO tblblooddonars 
                        (FullName, FatherName, MobileNumber, EmailId, Age, Gender, BloodGroup, last_donate, District, Thana, UnionName, Village, profile_photos, status, Password) 
                        VALUES 
                        (:fullname, :fathername, :mobile, :email, :age, :gender, :bloodgroup, :last_donate, :district, :thana, :union, :village, :profile_photo, :status, :password)";
                $query = $dbh->prepare($sql);
                $query->bindParam(':fullname', $fullname, PDO::PARAM_STR);
                $query->bindParam(':fathername', $fathername, PDO::PARAM_STR);
                $query->bindParam(':mobile', $mobile, PDO::PARAM_STR);
                $query->bindParam(':email', $email, PDO::PARAM_STR);
                $query->bindParam(':age', $age, PDO::PARAM_INT);
                $query->bindParam(':gender', $gender, PDO::PARAM_STR);
                $query->bindParam(':bloodgroup', $bloodgroup, PDO::PARAM_STR);
                $query->bindParam(':last_donate', $last_donate, PDO::PARAM_STR);
                $query->bindParam(':district', $district, PDO::PARAM_STR);
                $query->bindParam(':thana', $thana, PDO::PARAM_STR);
                $query->bindParam(':union', $union, PDO::PARAM_STR);
                $query->bindParam(':village', $village, PDO::PARAM_STR);
                $query->bindParam(':profile_photo', $fileName, PDO::PARAM_STR);
                $query->bindParam(':status', $status, PDO::PARAM_INT);
                $query->bindParam(':password', $password, PDO::PARAM_STR);
                $query->execute();

                $lastInsertId = $dbh->lastInsertId();
                if ($lastInsertId) {
                    echo "<script>alert('You have signed up successfully');</script>";
                    header("Location: login.php");
                    exit;
                } else {
                    echo "<script>alert('Something went wrong. Please try again.');</script>";
                }
            } else {
                echo "<script>alert('Email-id already exists. Please try again.');</script>";
            }
        } else {
            echo "<script>alert('Failed to upload profile photo. Please try again.');</script>";
        }
    } else {
        echo "<script>alert('Only JPG, JPEG, PNG files are allowed.');</script>";
    }
}
?>

<!-- HTML Form Code -->

<!DOCTYPE html>
<html lang="zxx">
<head>
    <title>Donor Registration Form | PKHBD</title>
    <link rel="stylesheet" href="css/bootstrap.css">
    <link rel="stylesheet" href="css/style.css">
    <script src="js/jquery-2.2.3.min.js"></script>
</head>
<body>
    <?php include('includes/header.php'); ?>
    <div class="container py-5 mt-5">
        <h5 class="text-center mb-4">Register Now</h5>
        <form action="" method="post" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" class="form-control" name="fullname" required>
                    </div>
                    <div class="form-group">
                        <label>Father's Name</label>
                        <input type="text" class="form-control" name="fathername" required>
                    </div>
                    <div class="form-group">
                        <label>Mobile Number</label>
                        <input type="text" class="form-control" name="mobileno" required maxlength="10">
                    </div>
                    
                    <div class="form-group">
                        <label>Age</label>
                        <select name="age" class="form-control" required>
                            <option value="">Select Age</option>
                            <?php for ($i = 18; $i <= 60; $i++) { ?>
                                <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Gender</label>
                        <select name="gender" class="form-control" required>
                            <option value="">Select Gender</option>
                            <option value="Male">Male</option>
                            <option value="Female">Female</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Blood Group</label>
                        <select name="bloodgroup" class="form-control" required>
                            <option value="">Select Blood Group</option>
                            <option value="A+">A+</option>
                            <option value="A-">A-</option>
                            <option value="B+">B+</option>
                            <option value="B-">B-</option>
                            <option value="AB+">AB+</option>
                            <option value="AB-">AB-</option>
                            <option value="O+">O+</option>
                            <option value="O-">O-</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Last Donate Date</label>
                        <input type="date" class="form-control" name="last_donate" >
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>District</label>
                        <select name="district" id="district" class="form-control" required>
                            <option value="">Select District</option>
                            <?php 
                            $sql = "SELECT DISTINCT district FROM locations";
                            $query = $dbh->prepare($sql);
                            $query->execute();
                            $results = $query->fetchAll(PDO::FETCH_OBJ);
                            foreach ($results as $result) { ?>
                                <option value="<?php echo htmlentities($result->district); ?>">
                                    <?php echo htmlentities($result->district); ?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Thana</label>
                        <select name="thana" id="thana" class="form-control" required>
                            <option value="">Select Thana</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Union</label>
                        <select name="union" id="union" class="form-control" required>
                            <option value="">Select Union</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Village</label>
                        <select name="village" id="village" class="form-control" required>
                            <option value="">Select Village</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Upload Profile Picture</label>
                        <input type="file" class="form-control" name="profile_photo" accept="image/*" required>
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" class="form-control" name="emailid" required>
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input type="password" class="form-control" name="password" required>
                    </div>
                </div>

                <div class="col">
                    <button type="submit" class="btn btn-primary w-100" name="submit">Register</button>
                </div>
            </div>
        </form>
    </div>

    
    <script>
        $(document).ready(function () {
            $('#district').change(function () {
                var district = $(this).val();
                $.ajax({
                    url: "get_data.php",
                    method: "POST",
                    data: { district: district },
                    success: function (data) {
                        $('#thana').html(data);
                    }
                });
            });

            $('#thana').change(function () {
                var thana = $(this).val();
                $.ajax({
                    url: "get_data.php",
                    method: "POST",
                    data: { thana: thana },
                    success: function (data) {
                        $('#union').html(data);
                    }
                });
            });

            $('#union').change(function () {
                var union = $(this).val();
                $.ajax({
                    url: "get_data.php",
                    method: "POST",
                    data: { union: union },
                    success: function (data) {
                        $('#village').html(data);
                    }
                });
            });
        });
    </script>
</body>
</html>

<!-- footer -->
<?php include('includes/footer.php');?>