<?php
session_start();
error_reporting(0);
include('includes/config.php');

if (strlen($_SESSION['bbdmsdid'] == 0)) {
    header('location:logout.php');
} else {
    if (isset($_POST['update'])) {
        try {
            $uid = $_SESSION['bbdmsdid'];
            $name = $_POST['fullname'];
            $mno = $_POST['mobileno']; 
            $emailid = $_POST['emailid'];
            $age = $_POST['age']; 
            $gender = $_POST['gender'];
            $bloodgroup = $_POST['bloodgroup']; 
            $last_donate = $_POST['last_donate']; // নতুন ফিল্ড

            
            // SQL আপডেট স্টেটমেন্ট
            $sql = "UPDATE tblblooddonars 
                    SET FullName = :name, MobileNumber = :mno, Age = :age, Gender = :gender, 
                        BloodGroup = :bloodgroup, last_donate = :last_donate 
                    WHERE id = :uid";
            
            $query = $dbh->prepare($sql);
            $query->bindParam(':name', $name, PDO::PARAM_STR);
            $query->bindParam(':mno', $mno, PDO::PARAM_STR);
            $query->bindParam(':age', $age, PDO::PARAM_STR);
            $query->bindParam(':gender', $gender, PDO::PARAM_STR);
            $query->bindParam(':bloodgroup', $bloodgroup, PDO::PARAM_STR);
            $query->bindParam(':last_donate', $last_donate, PDO::PARAM_STR);
            $query->bindParam(':uid', $uid, PDO::PARAM_STR);

            // কোয়েরি চালানো
            if ($query->execute()) {
                echo '<script>alert("Profile has been updated successfully!")</script>';
            } else {
                echo '<script>alert("Failed to update the profile. Please try again.")</script>';
            }
        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Donor Profile</title>
    <script>
        addEventListener("load", function () {
            setTimeout(hideURLbar, 0);
        }, false);

        function hideURLbar() {
            window.scrollTo(0, 1);
        }
    </script>
    <link rel="stylesheet" href="css/bootstrap.css">
    <link rel="stylesheet" href="css/style.css" type="text/css" media="all" />
    <link rel="stylesheet" href="css/fontawesome-all.css">
</head>
<body>
    <?php include('includes/header.php'); ?>
    <div class="appointment py-5">
        <div class="py-xl-5 py-lg-3">
            <div class="w3ls-titles text-center mb-3">
                <span><i class="fas fa-user-md"></i></span>
            </div>
            <div class="d-flex">

                <div class="contact-right-w3l appoint-form">
                    <h5 class="title-w3 text-center mb-5">Detail of Your Profile</h5>
                    <form action="#" method="post">
                        <?php
                        $uid = $_SESSION['bbdmsdid'];
                        $sql = "SELECT * FROM tblblooddonars WHERE id = :uid";
                        $query = $dbh->prepare($sql);
                        $query->bindParam(':uid', $uid, PDO::PARAM_STR);
                        $query->execute();
                        $results = $query->fetchAll(PDO::FETCH_OBJ);
                        if ($query->rowCount() > 0) {
                            foreach ($results as $row) { ?>
                                <div class="form-group">
                                    <label for="fullname" class="col-form-label">Full Name</label>
                                    <input type="text" class="form-control" name="fullname" value="<?php echo $row->FullName; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="mobileno" class="col-form-label">Mobile Number</label>
                                    <input type="text" class="form-control" name="mobileno" required pattern="[0-9]+" maxlength="10" value="<?php echo $row->MobileNumber; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="emailid" class="col-form-label">Email ID (Cannot be changed)</label>
                                    <input type="email" class="form-control" name="emailid" value="<?php echo $row->EmailId; ?>" readonly>
                                </div>
                                <div class="form-group">
                                    <label for="age" class="col-form-label">Age</label>
                                    <input type="text" class="form-control" name="age" required value="<?php echo $row->Age; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="gender" class="col-form-label">Gender</label>
                                    <select class="form-control" name="gender" required>
                                        <option value="<?php echo $row->Gender; ?>"><?php echo $row->Gender; ?></option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="bloodgroup" class="col-form-label">Blood Group</label>
                                    <select name="bloodgroup" class="form-control" required>
                                        <option value="<?php echo $row->BloodGroup; ?>"><?php echo $row->BloodGroup; ?></option>
                                        <?php
                                        $sql = "SELECT * FROM tblbloodgroup";
                                        $query = $dbh->prepare($sql);
                                        $query->execute();
                                        $groups = $query->fetchAll(PDO::FETCH_OBJ);
                                        foreach ($groups as $group) { ?>
                                            <option value="<?php echo htmlentities($group->BloodGroup); ?>"><?php echo htmlentities($group->BloodGroup); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="last_donate" class="col-form-label">Last Donate Date</label>
                                    <input type="date" class="form-control" name="last_donate" value="<?php echo $row->last_donate; ?>">
                                </div>                                
                            <?php } } ?>
                        <input type="submit" value="Update" name="update" class="btn_apt">
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php include('includes/footer.php'); ?>
</body>
</html>
<?php } ?>
