
<?php
error_reporting(0);
include('includes/config.php');
?>


<body>
	<?php include('includes/header.php');?>
	<!-- banner -->
	<div id="carouselExampleIndicators" class="carousel slide carousel-fade" data-ride="carousel" data-interval="3000">
			
			<div class="carousel-inner">
				<div class="carousel-item active" style="background-image: url('images/ban1.jpg');">
					<div class="carousel-caption d-none d-md-block"></div>
				</div>
				<div class="carousel-item" style="background-image: url('images/ban2.jpg');">
					<div class="carousel-caption d-none d-md-block"></div>
				</div>
				<div class="carousel-item" style="background-image: url('images/ban3.jpg');">
					<div class="carousel-caption d-none d-md-block"></div>
				</div>
			</div>
			<a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
				<span class="carousel-control-prev-icon" aria-hidden="true"></span>
				<span class="sr-only">Previous</span>
			</a>
			<a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
				<span class="carousel-control-next-icon" aria-hidden="true"></span>
				<span class="sr-only">Next</span>
			</a>
	</div>
		<style>
			.carousel-item {
				height: 580px;
				background-size: cover;
				background-position: center;
			}

			@media (max-width: 768px) {
				.carousel-item {
					height: 520px;
					background-size: cover;
					background-position: center;
				}
			}

			@media (max-width: 576px) {
				.carousel-item {
					height: 480px;
					background-size: cover;
					background-position: center;
				}
			}

			@media (max-width: 480px) {
				.carousel-item {
					height: 150px;
				}
			}
		</style>
	<!-- //banner -->
	<div class="clearfix"></div>
<!--//////////////////
Our Blood Donar List Start -->


<!-- Blood Group Summary Start -->
<div class="container mt-5">
    <div class="row">
        <?php
        $bloodGroups = ['A+', 'A-', 'B+', 'B-', 'O+', 'O-', 'AB+', 'AB-'];
        $status = 1;

        foreach ($bloodGroups as $bloodGroup) {
            // Count donors for each blood group
            $sql = "SELECT COUNT(*) as count FROM tblblooddonars WHERE BloodGroup=:bloodGroup AND status=:status";
            $query = $dbh->prepare($sql);
            $query->bindParam(':bloodGroup', $bloodGroup, PDO::PARAM_STR);
            $query->bindParam(':status', $status, PDO::PARAM_STR);
            $query->execute();
            $result = $query->fetch(PDO::FETCH_OBJ);
            $count = $result->count;
        ?>
            <!-- Bootstrap Responsive Grid -->
            <div class="col-lg-3 col-md-4 col-sm-6 col-6 mb-4 ">
                <a href="donor-list.php?bloodGroup=<?php echo urlencode($bloodGroup); ?>" class="text-decoration-none">
                    <div class="card text-center bg-red text-white">
                        <div class="card-body">
                            <h3 class="card-title">
                                <i class="fas fa-tint"></i> <?php echo htmlentities($bloodGroup); ?>
                            </h3>
                            <p class="card-text text-light">(<?php echo $count; ?>)</p>
                        </div>
                    </div>
                </a>
            </div>
        <?php } ?>
    </div>
</div>
<!-- Blood Group Summary End -->

<!-- Blood Donor Search Filter Start -->
<div class="blog-w3ls p-5" id="blog">
    <div class="container py-xl-5 py-lg-3">
        <!-- Search Form -->
        <form method="GET" action="" class="mb-4">
            <div class="row align-items-center">
                <div class="col-md-3">
                    <select name="district" class="form-control">
                        <option value="">Select District</option>
                        <?php
                        $sql = "SELECT DISTINCT District FROM tblblooddonars WHERE status=:status";
                        $query = $dbh->prepare($sql);
                        $query->bindParam(':status', $status, PDO::PARAM_STR);
                        $query->execute();
                        $districts = $query->fetchAll(PDO::FETCH_OBJ);
                        foreach ($districts as $district) {
                            echo '<option value="' . htmlentities($district->District) . '">' . htmlentities($district->District) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="thana" class="form-control">
                        <option value="">Select Thana</option>
                        <?php
                        $sql = "SELECT DISTINCT Thana FROM tblblooddonars WHERE status=:status";
                        $query = $dbh->prepare($sql);
                        $query->bindParam(':status', $status, PDO::PARAM_STR);
                        $query->execute();
                        $thanas = $query->fetchAll(PDO::FETCH_OBJ);
                        foreach ($thanas as $thana) {
                            echo '<option value="' . htmlentities($thana->Thana) . '">' . htmlentities($thana->Thana) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="union" class="form-control">
                        <option value="">Select Union</option>
                        <?php
                        $sql = "SELECT DISTINCT UnionName FROM tblblooddonars WHERE status=:status";
                        $query = $dbh->prepare($sql);
                        $query->bindParam(':status', $status, PDO::PARAM_STR);
                        $query->execute();
                        $unions = $query->fetchAll(PDO::FETCH_OBJ);
                        foreach ($unions as $union) {
                            echo '<option value="' . htmlentities($union->UnionName) . '">' . htmlentities($union->UnionName) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="blood_group" class="form-control">
                        <option value="">Select Blood Group</option>
                        <option value="A+">A+</option>
                        <option value="A-">A-</option>
                        <option value="B+">B+</option>
                        <option value="B-">B-</option>
                        <option value="O+">O+</option>
                        <option value="O-">O-</option>
                        <option value="AB+">AB+</option>
                        <option value="AB-">AB-</option>
                    </select>
                </div>
                <div class="col-md-1">
                    <select name="gender" class="form-control">
                        <option value="">Gender</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                    </select>
                </div>
                <div class="col-md-1 text-center p-1">
                    <button type="submit" class="btn btn-primary btn-block">Search</button>
                </div>
            </div>
        </form>

        <div class="text-center mb-4 pt-4">
            <h2 class="title fw-bold text-uppercase">Available Blood Donors</h2>
            <hr>
        </div>

        <div class="row package-grids mt-5">
            <!-- Donor Cards Code -->
            <?php
            $status = 1;
            $district = isset($_GET['district']) ? $_GET['district'] : '';
            $thana = isset($_GET['thana']) ? $_GET['thana'] : '';
            $union = isset($_GET['union']) ? $_GET['union'] : '';
            $blood_group = isset($_GET['blood_group']) ? $_GET['blood_group'] : '';
            $gender = isset($_GET['gender']) ? $_GET['gender'] : '';

            $sql = "SELECT * FROM tblblooddonars WHERE status=:status";
            $conditions = [];
            if ($district) {
                $conditions[] = "District=:district";
            }
            if ($thana) {
                $conditions[] = "Thana=:thana";
            }
            if ($union) {
                $conditions[] = "UnionName=:union";
            }
            if ($blood_group) {
                $conditions[] = "BloodGroup=:blood_group";
            }
            if ($gender) {
                $conditions[] = "Gender=:gender";
            }
            if (!empty($conditions)) {
                $sql .= " AND " . implode(" AND ", $conditions);
            }
            $sql .= " ORDER BY id DESC LIMIT 3";

            $query = $dbh->prepare($sql);
            $query->bindParam(':status', $status, PDO::PARAM_STR);
            if ($district) {
                $query->bindParam(':district', $district, PDO::PARAM_STR);
            }
            if ($thana) {
                $query->bindParam(':thana', $thana, PDO::PARAM_STR);
            }
            if ($union) {
                $query->bindParam(':union', $union, PDO::PARAM_STR);
            }
            if ($blood_group) {
                $query->bindParam(':blood_group', $blood_group, PDO::PARAM_STR);
            }
            if ($gender) {
                $query->bindParam(':gender', $gender, PDO::PARAM_STR);
            }
            $query->execute();
            $results = $query->fetchAll(PDO::FETCH_OBJ);

            if ($query->rowCount() > 0) {
                foreach ($results as $result) { ?>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="card shadow-sm border-0">
                            <div class="card-body text-center">
                                <img src="uploads/profile_photos/<?php echo htmlentities($result->profile_photos); ?>" 
                                     alt="Donor Image" 
                                     class="img-fluid rounded-circle mb-3" 
                                     style="width: 100px; height: 100px; object-fit: cover;">
                                <h5 class="card-title text-primary mb-2"><?php echo htmlentities($result->FullName); ?></h5>
                                <p class="card-text text-muted mb-4">Blood Group: <?php echo htmlentities($result->BloodGroup); ?></p>
                            </div>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item"><strong>Last Donate:</strong> <?php echo htmlentities($result->last_donate); ?></li>
                                <li class="list-group-item"><strong>Gender:</strong> <?php echo htmlentities($result->Gender); ?></li>
                                <li class="list-group-item"><strong>Mobile:</strong> <?php echo htmlentities($result->MobileNumber); ?></li>
                                <li class="list-group-item"><strong>Email:</strong> <?php echo htmlentities($result->EmailId); ?></li>
                                <li class="list-group-item">
                                    <strong>Address:</strong> 
                                    <?php echo htmlentities($result->District); ?>, 
                                    <?php echo htmlentities($result->Thana); ?>
                                </li>
                                <a href="contact-blood.php?cid=<?php echo $result->id; ?>" class="btn btn-danger btn-sm">Request to Donor</a>
                            </ul>
                        </div>
                    </div>
                <?php }
            } else { ?>
                <p class="text-center text-muted">No Donors Found</p>
            <?php } ?>
        </div>

        <div class="text-center mt-4">
            <a href="donar-list.php" class="btn btn-primary btn-lg">View All Donors</a>
        </div>
    </div>
</div>

<!-- Blood Donor Search Filter End -->
<!-- Custom CSS -->
<style>
    .card {
        border-radius: 10px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .card:hover {
        transform: scale(1.05);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
    }

    .card img {
        border: 3px solid #dc3545;
    }

    .card-title {
        font-size: 18px;
        font-weight: bold;
    }

    .card ul.list-group {
        font-size: 14px;
    }

    .btn-sm {
        padding: 8px 15px;
        font-size: 14px;
    }
</style>

<!-- Our Blood Donar List End -->


	<!-- footer -->
	<?php include('includes/footer.php');?>


	<!-- Js files -->
	<!-- JavaScript -->
	<script src="js/jquery-2.2.3.min.js"></script>
	<!-- Default-JavaScript-File -->

	<!-- banner slider -->
	<script src="js/responsiveslides.min.js"></script>
	<script>
		$(function () {
			$("#slider4").responsiveSlides({
				auto: true,
				pager: true,
				nav: true,
				speed: 1000,
				namespace: "callbacks",
				before: function () {
					$('.events').append("<li>before event fired.</li>");
				},
				after: function () {
					$('.events').append("<li>after event fired.</li>");
				}
			});
		});
	</script>
	<!-- //banner slider -->

	<!-- fixed navigation -->
	<script src="js/fixed-nav.js"></script>
	<!-- //fixed navigation -->

	<!-- smooth scrolling -->
	<script src="js/SmoothScroll.min.js"></script>
	<!-- move-top -->
	<script src="js/move-top.js"></script>
	<!-- easing -->
	<script src="js/easing.js"></script>
	<!--  necessary snippets for few javascript files -->
	<script src="js/medic.js"></script>

	<script src="js/bootstrap.js"></script>
	<!-- Necessary-JavaScript-File-For-Bootstrap -->

	<!-- //Js files -->

	<!-- jQuery -->
	<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
	<!-- Popper.js -->
	<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
	<!-- Bootstrap JS -->
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js">	
	</script>
</body>
</html>