<?php
include('includes/config.php');

if (isset($_POST['district'])) {
    $district = $_POST['district'];
    $sql = "SELECT DISTINCT thana FROM locations WHERE district=:district";
    $query = $dbh->prepare($sql);
    $query->bindParam(':district', $district, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);
    echo "<option value=''>Select Thana</option>";
    foreach ($results as $result) {
        echo "<option value='" . htmlentities($result->thana) . "'>" . htmlentities($result->thana) . "</option>";
    }
}

if (isset($_POST['thana'])) {
    $thana = $_POST['thana'];
    $sql = "SELECT DISTINCT union_name FROM locations WHERE thana=:thana";
    $query = $dbh->prepare($sql);
    $query->bindParam(':thana', $thana, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);
    echo "<option value=''>Select Union</option>";
    foreach ($results as $result) {
        echo "<option value='" . htmlentities($result->union_name) . "'>" . htmlentities($result->union_name) . "</option>";
    }
}

if (isset($_POST['union'])) {
    $union = $_POST['union'];
    $sql = "SELECT DISTINCT village FROM locations WHERE union_name=:union";
    $query = $dbh->prepare($sql);
    $query->bindParam(':union', $union, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);
    echo "<option value=''>Select Village</option>";
    foreach ($results as $result) {
        echo "<option value='" . htmlentities($result->village) . "'>" . htmlentities($result->village) . "</option>";
    }
}
?>
