<?php
error_reporting(0);
include('includes/config.php');
?>
<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Blood Bank Donor Management System | Home Page</title>

    <script>
        addEventListener("load", function () {
            setTimeout(hideURLbar, 0);
        }, false);

        function hideURLbar() {
            window.scrollTo(0, 1);
        }
    </script>

    <!-- Custom-Files -->
    <link rel="stylesheet" href="css/bootstrap.css">
    <link rel="stylesheet" href="css/style.css" type="text/css" media="all" />
    <link rel="stylesheet" href="css/fontawesome-all.css">

    <!-- Web-Fonts -->
    <link href="//fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese" rel="stylesheet">
    <link href="//fonts.googleapis.com/css?family=Roboto+Condensed:300,300i,400,400i,700,700i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese" rel="stylesheet">
    <!-- //Web-Fonts -->

    <style>
        @media (max-width: 576px) {
            .card img {
                width: 100px;
                height: 100px;
            }

            .btn {
                font-size: 12px;
                padding: 5px 10px;
            }
        }
    </style>
</head>

<body>
    <?php include('includes/header.php'); ?>

    <div class="container mt-5 py-5">
        <div class="text-center mb-4">
            <h2 class="title">Available Blood Donors</h2>
            <hr>
        </div>

        <!-- Search Form -->
        <form method="GET" action="">
            <div class="row">
                <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-2">
                    <select name="district" class="form-control">
                        <option value="">Select District</option>
                        <?php
                        $status = 1;
                        $sql = "SELECT DISTINCT District FROM tblblooddonars WHERE status=:status";
                        $query = $dbh->prepare($sql);
                        $query->bindParam(':status', $status, PDO::PARAM_STR);
                        $query->execute();
                        $districts = $query->fetchAll(PDO::FETCH_OBJ);
                        foreach ($districts as $district) {
                            echo '<option value="' . htmlentities($district->District) . '">' . htmlentities($district->District) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-2">
                    <select name="thana" class="form-control">
                        <option value="">Select Thana</option>
                        <?php
                        $sql = "SELECT DISTINCT Thana FROM tblblooddonars WHERE status=:status";
                        $query = $dbh->prepare($sql);
                        $query->bindParam(':status', $status, PDO::PARAM_STR);
                        $query->execute();
                        $thanas = $query->fetchAll(PDO::FETCH_OBJ);
                        foreach ($thanas as $thana) {
                            echo '<option value="' . htmlentities($thana->Thana) . '">' . htmlentities($thana->Thana) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-2">
                    <select name="union" class="form-control">
                        <option value="">Select Union</option>
                        <?php
                        $sql = "SELECT DISTINCT UnionName FROM tblblooddonars WHERE status=:status";
                        $query = $dbh->prepare($sql);
                        $query->bindParam(':status', $status, PDO::PARAM_STR);
                        $query->execute();
                        $unions = $query->fetchAll(PDO::FETCH_OBJ);
                        foreach ($unions as $union) {
                            echo '<option value="' . htmlentities($union->UnionName) . '">' . htmlentities($union->UnionName) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-6 col-6 mb-2">
                    <select name="blood_group" class="form-control">
                        <option value="">Select Blood Group</option>
                        <option value="A+">A+</option>
                        <option value="A-">A-</option>
                        <option value="B+">B+</option>
                        <option value="B-">B-</option>
                        <option value="O+">O+</option>
                        <option value="O-">O-</option>
                        <option value="AB+">AB+</option>
                        <option value="AB-">AB-</option>
                    </select>
                </div>
                <div class="col-lg-1 col-md-4 col-sm-6 col-6 mb-2">
                    <select name="gender" class="form-control">
                        <option value="">Gender</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                    </select>
                </div>
                <div class="col-lg-1 col-md-12 col-sm-12 col-12 mb-2">
                    <button type="submit" class="btn btn-primary btn-block">Search</button>
                </div>
            </div>
        </form>

        <!-- Donor Cards -->
        <div class="row mt-5">
            <?php
            $status = 1;
            $limit = 6;
            $page = isset($_GET['page']) ? $_GET['page'] : 1;
            $offset = ($page - 1) * $limit;

            $conditions = [];
            $params = [':status' => $status];

            if (!empty($_GET['district'])) {
                $conditions[] = "District = :district";
                $params[':district'] = $_GET['district'];
            }
            if (!empty($_GET['thana'])) {
                $conditions[] = "Thana = :thana";
                $params[':thana'] = $_GET['thana'];
            }
            if (!empty($_GET['union'])) {
                $conditions[] = "UnionName = :union";
                $params[':union'] = $_GET['union'];
            }
            if (!empty($_GET['blood_group'])) {
                $conditions[] = "BloodGroup = :blood_group";
                $params[':blood_group'] = $_GET['blood_group'];
            }
            if (!empty($_GET['gender'])) {
                $conditions[] = "Gender = :gender";
                $params[':gender'] = $_GET['gender'];
            }

            $sql = "SELECT * FROM tblblooddonars WHERE status = :status";
            if ($conditions) {
                $sql .= " AND " . implode(" AND ", $conditions);
            }
            $sql .= " ORDER BY id DESC LIMIT :limit OFFSET :offset";

            $query = $dbh->prepare($sql);
            foreach ($params as $key => &$value) {
                $query->bindParam($key, $value, PDO::PARAM_STR);
            }
            $query->bindParam(':limit', $limit, PDO::PARAM_INT);
            $query->bindParam(':offset', $offset, PDO::PARAM_INT);
            $query->execute();
            $results = $query->fetchAll(PDO::FETCH_OBJ);

            if ($query->rowCount() > 0) {
                foreach ($results as $result) { ?>
                    <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
                        <div class="card">
                            <div class="card-body text-center">
                                <img style="width: 150px; height: 150px; object-fit: cover;" src="uploads/profile_photos/<?php echo htmlentities($result->profile_photos); ?>" alt="" class="img-fluid rounded-circle mb-3">
                                <h5><?php echo htmlentities($result->FullName); ?></h5>
                                <p>Blood Group: <?php echo htmlentities($result->BloodGroup); ?></p>
                                <p>Gender: <?php echo htmlentities($result->Gender); ?></p>
                                <p><strong>Address:</strong> <?php echo htmlentities($result->District); ?>, <?php echo htmlentities($result->Thana); ?></p>
                                <p>Mob: <?php echo htmlentities($result->MobileNumber); ?></p>
                                <a href="contact-blood.php?cid=<?php echo $result->id; ?>" class="btn btn-danger">Request</a>
                            </div>
                        </div>
                    </div>
                <?php }
            } else {
                echo '<p class="text-center">No Donors Found</p>';
            }
            ?>
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-center mt-4">
            <ul class="pagination">
                <?php
                $sql = "SELECT COUNT(*) FROM tblblooddonars WHERE status = :status";
                if ($conditions) {
                    $sql .= " AND " . implode(" AND ", $conditions);
                }
                $query = $dbh->prepare($sql);
                foreach ($params as $key => &$value) {
                    $query->bindParam($key, $value, PDO::PARAM_STR);
                }
                $query->execute();
                $total_rows = $query->fetchColumn();
                $total_pages = ceil($total_rows / $limit);

                for ($i = 1; $i <= $total_pages; $i++) {
                    echo '<li class="page-item ' . ($i == $page ? 'active' : '') . '"><a class="page-link" href="?page=' . $i . '">' . $i . '</a></li>';
                }
                ?>
            </ul>
        </div>
    </div>




<?php include('includes/footer.php');?>