<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sidebar with Toggle</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">

    <style>
        /* Sidebar fixed to the left */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: 240px; /* Set the width of the sidebar */
            height: 100vh;
            z-index: 1000;
            background-color: red;
            transition: width 0.3s; /* Smooth transition for expanding the sidebar */
        }

        .sidebar.active {
            width: 0; /* Collapse sidebar when active */
			
        }

        .sidebar:hover {
            background-color: red;
           
			
        }

        /* To adjust the content area when sidebar is fixed */
        .content {
            margin-left: 260px; /* Adjust this to match the sidebar width */
            transition: margin-left 0.3s;
            background-color: red;
			
        }

        .sidebar i {
            font-size: 14px; /* Adjust icon size */
            color: white;
            margin-right: 10px;
            
			
        }

        .nav-item {
            padding: 5px 5px; /* Adjust padding for better spacing */
			color: white;
            background-color: red;
        }

		.nav-item:hover {
            padding: 5px 5px; /* Adjust padding for better spacing */
			
        }

        .nav-link {
            color: white !important;
            font-size: 14px;
            display: flex;
            align-items: center;
        }

        .nav-link:hover {
			color: black; 
        }

        .collapse {
            padding-left: 20px;
        }

        /* Ensuring the sidebar collapses correctly in mobile view */
        @media (max-width: 768px) {
            .sidebar {
                width: 100%; /* Full width on mobile */
                height: auto;
                position: absolute;
                top: 0;
                left: -100%; /* Initially hidden */
                transition: left 0.3s;
            }

            .sidebar.active {
                left: 0; /* Slide in the sidebar when toggled */
            }

            .content {
                margin-left: 0; /* No margin for content on mobile */
            }

            /* Toggle button for mobile */
            .navbar-toggler {
                display: block;
                 /* Adjust color */
                border: none;
				border-radius: 30px;
            }

            .navbar-toggler-icon {
				border-radius: 30px;
                background-color: white; /* Change color of the hamburger icon */
            }
        }
    </style>
</head>
<body>

<!-- Navbar with Toggle Button -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarContent" aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <a class="navbar-brand" href="#">PKH</a>
</nav>

<!-- Sidebar -->
<nav class="d-lg-block bg-light sidebar" id="sidebar">
    <ul class="nav flex-column">
        <li class="nav-item">
            <a class="nav-link active" href="dashboard.php">
                <i class="fa fa-dashboard"></i> Dashboard
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="#bloodGroupSubmenu" data-toggle="collapse" aria-expanded="false" aria-controls="bloodGroupSubmenu">
                <i class="fa fa-files-o"></i> Blood Group
            </a>
            <div class="collapse" id="bloodGroupSubmenu">
                <ul class="nav flex-column ml-3">
                    <li class="nav-item">
                        <a class="nav-link" href="add-bloodgroup.php">Add Blood Group</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="manage-bloodgroup.php">Manage Blood Group</a>
                    </li>
                </ul>
            </div>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="#locationSubmenu" data-toggle="collapse" aria-expanded="false" aria-controls="locationSubmenu">
                <i class="fa fa-files-o"></i> Location
            </a>
            <div class="collapse" id="locationSubmenu">
                <ul class="nav flex-column ml-3">
                    <li class="nav-item">
                        <a class="nav-link" href="district.php">Add Location</a>
                    </li>
                </ul>
            </div>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="donor-list.php">
                <i class="fa fa-users"></i> Donor List
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="manage-conactusquery.php">
                <i class="fa fa-desktop"></i> Manage Contact Us Query
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="manage-pages.php">
                <i class="fa fa-files-o"></i> Manage Pages
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="update-contactinfo.php">
                <i class="fa fa-files-o"></i> Update Contact Info
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="blood-requests.php">
                <i class="fa fa-users"></i> Blood Requests
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="request-received-bydonar.php">
                <i class="fa fa-search"></i> Search Blood Request
            </a>
        </li>
    </ul>
</nav>

<!-- Main content -->
<!-- <div class="content">
    <div class="container">
        <h1>Welcome to the Dashboard</h1>

    </div>
</div> -->

<!-- Responsive Design Scripts -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
    // Toggle sidebar on mobile
    $('.navbar-toggler').click(function() {
        $('#sidebar').toggleClass('active');
    });
</script>

</body>
</html>
