<?php
session_start();
error_reporting(0);

if (strlen($_SESSION['alogin']) == 0) {
    header('location:index.php');
}

// Database Connection
$host = 'localhost';
$dbname = 'rokto';
$user = 'root';
$password = '';

try {
    $dbh = new PDO("mysql:host=$host;dbname=$dbname", $user, $password);
    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Insert Data
if (isset($_POST['submit'])) {
    $district = $_POST['district'];
    $thana = $_POST['thana'];
    $union = $_POST['union'];
    $village = $_POST['village'];

    $sql = "INSERT INTO locations (district, thana, union_name, village) VALUES (:district, :thana, :union, :village)";
    $query = $dbh->prepare($sql);
    $query->bindParam(':district', $district);
    $query->bindParam(':thana', $thana);
    $query->bindParam(':union', $union);
    $query->bindParam(':village', $village);
    $query->execute();

    header("Location: district.php");
    exit();
}

// Delete Data
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $sql = "DELETE FROM locations WHERE id = :id";
    $query = $dbh->prepare($sql);
    $query->bindParam(':id', $id);
    $query->execute();

    header("Location: district.php");
    exit();
}

// Fetch Data for Update
$editData = [];
if (isset($_GET['edit'])) {
    $id = $_GET['edit'];
    $sql = "SELECT * FROM locations WHERE id = :id";
    $query = $dbh->prepare($sql);
    $query->bindParam(':id', $id);
    $query->execute();
    $editData = $query->fetch(PDO::FETCH_ASSOC);
}

// Update Data
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $district = $_POST['district'];
    $thana = $_POST['thana'];
    $union = $_POST['union'];
    $village = $_POST['village'];

    $sql = "UPDATE locations SET district = :district, thana = :thana, union_name = :union, village = :village WHERE id = :id";
    $query = $dbh->prepare($sql);
    $query->bindParam(':district', $district);
    $query->bindParam(':thana', $thana);
    $query->bindParam(':union', $union);
    $query->bindParam(':village', $village);
    $query->bindParam(':id', $id);
    $query->execute();

    header("Location: district.php");
    exit();
}
?>
<!doctype html>
<html lang="en" class="no-js">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
	<meta name="description" content="">
	<meta name="author" content="">
	<meta name="theme-color" content="#3e454c">
	
	<title>PKH | Location Dashboard</title>

</head>

<body>
<?php include('includes/header.php');?>
<?php include('includes/leftbar.php');?>

<div class="container mt-5">
    <button class="btn btn-primary mb-3" data-toggle="modal" data-target="#addModal">Add New Location</button>
    <input type="text" id="searchInput" class="form-control mb-3" placeholder="Search by Thana, Union, or Village...">
    
    <table class="table table-bordered" id="locationTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>District</th>
                <th>Thana</th>
                <th>Union</th>
                <th>Village</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql = "SELECT * FROM locations";
            $query = $dbh->prepare($sql);
            $query->execute();
            $results = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach ($results as $row) {
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['district']}</td>
                        <td>{$row['thana']}</td>
                        <td>{$row['union_name']}</td>
                        <td>{$row['village']}</td>
                        <td>
                            <button 
                                class='btn btn-sm btn-warning editBtn' 
                                data-id='{$row['id']}'
                                data-district='{$row['district']}'
                                data-thana='{$row['thana']}'
                                data-union='{$row['union_name']}'
                                data-village='{$row['village']}'>
                                Edit
                            </button>
                            <a href='district.php?delete={$row['id']}' class='btn btn-sm btn-danger'>Delete</a>
                        </td>
                      </tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="">
                <div class="modal-header">
                    <h5 class="modal-title" id="addModalLabel">Add New Location</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>District</label>
                        <input type="text" name="district" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Thana</label>
                        <input type="text" name="thana" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Union</label>
                        <input type="text" name="union" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Village</label>
                        <input type="text" name="village" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" name="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="">
                <input type="hidden" name="id" id="edit_id">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Edit Location</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>District</label>
                        <input type="text" name="district" id="edit_district" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Thana</label>
                        <input type="text" name="thana" id="edit_thana" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Union</label>
                        <input type="text" name="union" id="edit_union" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Village</label>
                        <input type="text" name="village" id="edit_village" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" name="update" class="btn btn-warning">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    $(document).ready(function () {
        // Edit button click event
        $('.editBtn').click(function () {
            var id = $(this).data('id');
            var district = $(this).data('district');
            var thana = $(this).data('thana');
            var union = $(this).data('union');
            var village = $(this).data('village');

            $('#edit_id').val(id);
            $('#edit_district').val(district);
            $('#edit_thana').val(thana);
            $('#edit_union').val(union);
            $('#edit_village').val(village);

            $('#editModal').modal('show');
        });

        // Search filter
        $('#searchInput').on('keyup', function () {
            var value = $(this).val().toLowerCase();
            $('#locationTable tbody tr').filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        });
    });
</script>
</body>
</html>
